clear all
%Model preliminaries 
ngrid=501;
c_upper=zeros(1,ngrid);
c_lower1=zeros(1,ngrid);
c_lower2=zeros(1,ngrid);
c_lower3=zeros(1,ngrid);
Delta=0.2; 
Rd=1.04;
P=1.20;
gamma=1.2; 

%%
%An economy without guarantors 
omega1=0.0001;
omega2=0.001;
omega3=0.0031; 

%Solve phi_star 
%Parameterization 1 
pi_fun=@(x)(x-(1+1/gamma)*(omega1*gamma)^(1/(gamma+1))*x^(gamma/(gamma+1))+omega1-Rd);
phi_grid=linspace(0,5,ngrid);
pi_grid=zeros(1,ngrid);
x=linspace(0,1,ngrid);
for i=1:ngrid
    pi_grid(i)=pi_fun(phi_grid(i));
end 

figure 
plot(phi_grid,pi_grid)
[zpc,index]=min(abs(pi_grid));
phi_star1=phi_grid(index); 

if phi_star1>P || phi_star1<omega1*gamma 
    error('phi_star is out of range') 
end 


%Parameterization 2
pi_fun=@(x)(x-(1+1/gamma)*(omega2*gamma)^(1/(gamma+1))*x^(gamma/(gamma+1))+omega2-Rd);
for i=1:ngrid
    pi_grid(i)=pi_fun(phi_grid(i));
end 

[zpc,index]=min(abs(pi_grid));
phi_star2=phi_grid(index); 

if phi_star2>P || phi_star2<omega2*gamma 
    error('phi_star is out of range') 
end 

%Paramerization 3
pi_fun=@(x)(x-(1+1/gamma)*(omega3*gamma)^(1/(gamma+1))*x^(gamma/(gamma+1))+omega3-Rd);
for i=1:ngrid
    pi_grid(i)=pi_fun(phi_grid(i));
end 

[zpc,index]=min(abs(pi_grid));
phi_star3=phi_grid(index); 

if phi_star3>P || phi_star3<omega3*gamma 
    error('phi_star is out of range') 
end 

for i=1:ngrid
    if x(i)<Delta 
        xhat=0.5*(x(i)+Delta);
    elseif x(i)>1-Delta 
        xhat=0.5*(1+x(i)-Delta); 
    else 
        xhat=x(i);
    end 
    
    c_upper(i)=max((Rd-P*(1-xhat))/xhat,0);
    xhhat=max(x(i)-Delta,0);
    c_lower1(i)=max((phi_star1-P*(1-xhhat))/xhhat,0);
    c_lower2(i)=max((phi_star2-P*(1-xhhat))/xhhat,0);
    c_lower3(i)=max((phi_star3-P*(1-xhhat))/xhhat,0);
end 

mediocre_upperx1=min((P-Rd)*Delta/(phi_star1-Rd),1-Delta);
mediocre_upperx2=min((P-Rd)*Delta/(phi_star2-Rd),1-Delta);
mediocre_upperx3=min((P-Rd)*Delta/(phi_star3-Rd),1-Delta);

poor_upper1=min((0.5*P-0.5*phi_star1)/(0.5*P+0.5*phi_star1-Rd),1);
poor_upper2=min((0.5*P-0.5*phi_star2)/(0.5*P+0.5*phi_star2-Rd),1);
poor_upper3=min((0.5*P-0.5*phi_star3)/(0.5*P+0.5*phi_star3-Rd),1);


%%
sky_blue = [135 206 250]./255;
light_grey = [211 211 211]./255;
light_pink = [255 192 203]./255;

figure 
h1 = plot(x,c_upper,'k-', 'LineWidth', 1.5);
hold on;
h2 = plot(x,c_lower1,'r-.', 'LineWidth', 1.5);
hold on;
h3 = plot(x,c_lower2,'r--', 'LineWidth', 1.5);
hold on
h4 = plot(x,c_lower3,'r:', 'LineWidth', 1.5);
xlabel('Balance sheet signal x', 'FontSize', 14)
ylabel('Collateral c', 'FontSize', 14)
title('', 'Interpreter', 'latex', 'FontSize', 14)


xxx=x(c_upper>c_lower1);  yyy_up = c_upper(c_upper>c_lower1); yyy_down = c_lower1(c_upper>c_lower1);
h5 = fill([xxx, fliplr(xxx)], [yyy_up,  fliplr(yyy_down)], sky_blue, 'EdgeColor', 'none'); hold on; alpha(0.4);

xxx2=x(c_upper>c_lower2);  yyy_up2 = c_upper(c_upper>c_lower2); yyy_down2 = c_lower2(c_upper>c_lower2);
h6 = fill([xxx2, fliplr(xxx2)], [yyy_up2,  fliplr(yyy_down2)], light_pink, 'EdgeColor', 'none'); hold on; alpha(0.4);

legend([h1 h2 h3 h4 h5 h6], '$\bar{c}$','$\underline{c}: \omega=.0001$','$\underline{c}: \omega=.001$','$\underline{c}: \omega=.0031$',...
    'Project funded: $\omega = .0001$', ...
    'Project funded: $\omega = .001$', 'Interpreter','latex','Location','southeast', 'FontSize', 14);
%set(h,'Interpreter','latex','Location','southwest')

set(gcf, 'Position', [10 10 800 600]);
saveas(gcf, './cstatics_omega.eps', 'epsc')




